<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nicolas S.F</title>
    <link rel="icon" href="images/codigo.png">
    <!-- Font de icons remix -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.2.0/remixicon.min.css">
    <link rel="stylesheet" href="css/style.css">
    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">

</head>

<body>

    <!-- Menu -->
    <nav>
        <div class="nav-logo">
            <a href="">
                <p>Nicolas S.F</p>
            </a>
        </div>
        <ul class="nav-links">
            <li id="link1" class="link"><a href="#">Sobre</a></li>
            <li id="link2" class="link"><a href="#">Experiências</a></li>
            <li id="link3" class="link"><a href="#">Conhecimentos</a></li>
            <li id="link4" class="link"><a href="#">Projetos</a></li>
        </ul>

    </nav>
    <!-- Fim menu -->


    <!-- Header foto -->
    <header class="container">
        <div class="content">
            <span class="blur"></span>
            <span class="blur"></span>

            <h1 class="sobre">
                Nicolas Fernandes
            </h1>
            <h1 class="typing-text">

                <span class="auto-type"></span>
            </h1>

            <div class="btn-container">
                <button class="btn btn-color-2" id="openPdfButton">Curriculo</button>
                <button class="btn btn-color-1">Contato info</button>
            </div>

            <div id="socials-container">
                <a href="https://www.linkedin.com/in/nicolas-fernandes-200807250/" target="_blank"><i
                        class="ri-linkedin-box-fill"></i></a>
                <a href="https://github.com/nicolasSafer" target="_blank"><i class="ri-github-fill"></i></a>
                <a href="https://wa.me/qr/ZIEQKCM5LFH5K1" target="_blank"><i class="ri-whatsapp-fill"></i></a>
            </div>

        </div>
        <div class="image">
            <img src="images/header.png" alt="">

        </div>

    </header>
    <!-- Fim header topo -->



    <!-- Section sobre  -->
    <section class="container " id="about">

        <p class="sub-header">Conheça mais</p>
        <h2 class="header">Sobre mim</h2>
        <div class="section-container">
            <div class="about-details-container">
                <div class="about-containers">
                    <div class="details-container">
                        <!-- <i class="ri-award-fill"></i> -->
                        <h3>Experiências</h3>
                        <p>
                            2+ Anos
                            <br>
                            Backend e Frontend
                        </p>
                    </div>
                    <div class="details-container">
                        <!-- <i class="ri-git-repository-fill"></i> -->
                        <h3>Estudos</h3>
                        <p>
                            Cursando
                            <br>
                            Analise e desenvolvimento de sistemas
                        </p>
                    </div>
                </div>
                <p>Trabalho há 2 anos como freelancer desenvolvendo websites para empresas, além de realizar projetos de
                    automação, sistemas WEB e desktop. Também participei do desenvolvimento de sistemas para diversas
                    prefeituras em todo o Brasil, atendendo setores como gerenciamento de medicamentos, frotas e gestão
                    predial.

                </p>
            </div>
        </div>



    </section>
    <!-- Fim Section sobre -->


    <!-- Div titulo timeline -->
    <div class="titulo">
        <h2 class="tl">Timeline</h2>
        <p>Um pouco da minha carreira profissional e estudos </p>
    </div>
    <!-- Section timeline  -->
    <section class="timeline">

        <div class="timeline-row">
            <div class="timeline-column">
                <h2 class="title">Educação <span class="animate" style="--i:1;"></span></h2>
                <div class="timeline-box">
                    <div class="timeline-content">
                        <div class="content">
                            <div class="year"></i>2018 - 2022: Concluído</div>
                            <h3>Ensino Médio Técnico: </h3>
                            <p>No colécio CEEP (Centro Estadual de Educação Profissional do Paraná) realizei o curso
                                técnico de edificações integrado com o ensino médio</p>
                        </div>
                    </div>

                    <div class="timeline-content">
                        <div class="content">
                            <div class="year"></i>2019 - 2020: Concluído</div>
                            <h3>Suporte Técnico em TI (FIEP - SENAI):</h3>
                            <p> Curso voltado à área da Tecnologia de Informação, aprendizado de ferramentas e programas
                                para o suporte técnico e
                                manutenção de computadores, redes e servidores. </p>
                        </div>
                    </div>

                    <div class="timeline-content">
                        <div class="content">
                            <div class="year"></i>2021 - 2022: Concluído</div>
                            <h3>Técnico em Desenvolvimento de Sistemas (FIEP - SENAI): </h3>
                            <p>Curso voltado na área de tecnologia e programação Sistema, desenvolvendo sistemas WEB e
                                Desktop aplicando metodos de programação orientado a objeto (POO) e
                                Model-View-Controller (MVC).</p>
                        </div>
                    </div>

                    <div class="timeline-content">
                        <div class="content">
                            <div class="year"></i>2024 - Atual</div>
                            <h3>Ensino Superior (Universidade UniBrasil)</h3>
                            <p>Atualmente, estou cursando Análise e Desenvolvimento de Sistemas, onde tenho adquirido
                                uma ampla gama de referências e conhecimentos. Isso tem me permitido aplicar e aprimorar
                                meus estudos e projetos profissionais. Estou capacitado para analisar e desenvolver
                                sistemas completos, focando em alta performance e eficiência.</p>
                        </div>
                    </div>
                    <span class="animate" style="--i:2;"></span>
                </div>
            </div>





            <div class="timeline-column">
                <h2 class="title">Experiências <span class="animate" style="--i:4;"></span></h2>
                <div class="timeline-box">
                    <div class="timeline-content">
                        <div class="content">
                            <div class="year">2023 - 2023</div>
                            <h3>Backend - Grupo Carletto: </h3>
                            <p>
                                - Desenvolvimento e Manutenção de aplicações Web com consultas, parametrizações e
                                cotações utilizando PHP, HTML, CSS e ScriptCase;
                                <br>
                                - Planejamento e desenvolvimento dos bancos de dados relacionais e comunicação com API;
                                <br>
                                - Suporte técnico para resoluções de bugs.
                            </p>
                        </div>
                    </div>

                    <div class="timeline-content">
                        <div class="content">
                            <div class="year">2023 - 2024</div>
                            <h3>Fullstack - Brasil Predial:</h3>
                            <p>
                                - Desenvolvimento de aplicações Web utilizando PHP, HTML, CSS e ScriptCase;
                                <br>
                                - Planejamento e desenvolvimento dos bancos de dados relacionais e comunicação com API;
                                <br>
                                - Suporte técnico para resoluções de bugs.
                            </p>
                        </div>
                    </div>



                    <div class="timeline-content">
                        <div class="content">
                            <div class="year">2024 - Atual</div>
                            <h3>Fullstack - BESTSTART:</h3>
                            <p>Desenvolvimento Web site e sistemas com foco no gerenciamento para auto-peça e
                                auto-center </p>
                        </div>
                    </div>
                    <div class="timeline-content">
                        <div class="content">
                            <div class="year">2024 - Atual</div>
                            <h3>Fullstack - QFROTAS:</h3>
                            <p>Desenvolvimento Web site e sistemas com foco no gerenciamento para auto-peça e
                                para gestão de frota </p>
                        </div>
                    </div>
                    <span class="animate" style="--i:5;"></span>
                </div>
            </div>
        </div>

    </section>
    <!-- Fim section timeline -->


    <!-- Div titulo skills -->
    <div class="titulo">
        <h2 class="conhecimento">Conhecimentos</h2>
        <p>Possuo experiências com diferentes linguagens e frameworks para desenvolvimento de aplicações e paginas web
        </p>
    </div>
    <!-- Sectiion skills -->
    <section class="skills" id="skills">
        <div class="container-con">


            <div class="container" style="margin-bottom: 0px;">
                <p>Conhecimentos Frontend</p>

                <div class="row" id="skillsContainer">
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/html5.png" alt="" style="width: 70px;">
                            <span>HTML5</span>
                            <p>Avançado</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 5+ anos</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/css.png" alt="" style="width: 70px;">
                            <span>CSS3</span>
                            <p>Intermediário</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 5+ anos</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/bootstrap.jpg" alt="" style="width: 85px;">
                            <span>Bootstrap</span>
                            <p>Avançado</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 ano</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/javascript-.png" alt="" style="width: 70px;">
                            <span>JavaScript</span>
                            <p>Básico</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 ano</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/ajax.png" alt="" style="width: 100px;">
                            <span>Ajax</span>
                            <p>Básico</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 mês</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>

                            </ul>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <p>Conhecimentos Backend</p>
                <div class="row" id="skillsContainer">
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/php.png" alt="" style="width: 70px;">
                            <span>PHP</span>
                            <p>Avançado</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 2 anos</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/laravel.png" alt="" style="width: 70px;">
                            <span>Laravel</span>
                            <p>Básico</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 6 meses</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>

                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/mysql.png" alt="" style="width: 70px;">
                            <span>MySQL</span>
                            <p>Avançado</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 4+ anos</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/c-sharp.png" alt="" style="width: 70px;">
                            <span>C#</span>
                            <p>Intermediário</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 ano</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>

                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/c.png" alt="" style="width: 70px;">
                            <span>C</span>
                            <p>Intermediário</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 ano</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>

                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/API.png" alt="" style="width: 70px;">
                            <span>API's</span>
                            <p>Básico</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 6 meses</p>
                                </li>
                                <li>
                                    <p>Projetos pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/git.png" alt="" style="width: 70px;">
                            <span>GIT</span>
                            <p>Intermediário</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 1 ano</p>
                                </li>
                                <li>
                                    <p>Aplicações pessoais</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                    <div class="bar card">
                        <div class="card-front info">
                            <img src="images/scriptcase.png" alt="" style="width: 70px;">
                            <span>ScriptCase</span>
                            <p>Avançado</p>
                        </div>
                        <div class="card-back info">
                            <p>
                            <ul>
                                <li>
                                    <p>Estudos 2 ano</p>
                                </li>
                                <li>
                                    <p>Projetos profissionais</p>
                                </li>
                            </ul>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- Fim section skills -->

    <!-- Section projetos -->

    <div class="titulo ">
        <h2 class="tl ">Projetos</h2>
        <p>Alguns projetos de estudos e profissionais</p>
    </div>

    <section class="projects">
        <div class="wrapper projetos">
            <div class="container-project">         
                <input type="radio" name="slide" class="test" id="c1" checked >
                <label for="c1" class="card-project">
                    <div class="row-project">
                        <div class="icon">1</div>
                        <div class="description">
                            <h4>BESTSTART - Profissional</h4>
                            <p>Projeto pessoal para gerenciamento de oficinas</p>
                        </div>
                    </div>
                </label>
                <input type="radio" name="slide" id="c2" >
                <label for="c2" class="card-project">
                    <div class="row-project">
                        <div class="icon">2</div>
                        <div class="description">
                            <h4>Finans - Estudos</h4>
                            <p>Projeto desenvolvido de estudos</p>
                        </div>
                    </div>
                </label>
                <input type="radio" name="slide" id="c3" >
                <label for="c3" class="card-project">
                    <div class="row-project">
                        <div class="icon">3</div>
                        <div class="description">
                            <h4>SGO - Profissional</h4>
                            <p>Sistema para gerencimento de frotas das prefeituras <a href="">link</a></p>
                        </div>
                    </div>
                </label>

            
            </div>
        </div>
    </section> 
    <!-- Fim section projetos -->


    <div class="titulo">
        <h2 class="conhecimento">Vamos trabalhar junto?</h2>
        <p>Envie-me um e-mail para <b>iniciarmos seu projeto.</b></p>
    </div>

    <section class="form-email">
        <form action="enviar.php" name="FormEnvia" method="POST" data-form>
            <label for="nome">Nome</label>
            <input type="text" name="nome"  id="nome" required />
            <label for="email">E-mail</label>
            <input type="email" name="email"  id="email" required />
            <label for="mensagem">Mensagem</label>
            <textarea name="mensagem" id="mensagem"></textarea>
            <button type="submit" name="FormEnvia" class="email" data="button">Enviar</button>

        </form>

    </section>






    <!-- Inicio rodapé -->
    <footer class="footer-container">
        <div class="copyright">
            Copyright © 2024 Nicolas. Web Developer
        </div>
    </footer>
    <!-- Fim rodapé -->



    <script src="https://unpkg.com/typed.js@2.1.0/dist/typed.umd.js"></script>

    <!-- Script para infinity type no header -->
    <script>
        var typed = new Typed(".auto-type", {
            strings: ["Programador", "Backend Developer", "Frontend Developer"],
            typeSpeed: 70,
            backSpeed: 30,
            loop: true,
            cursorChar: "|",
            loopCount: Infinity
        })
    </script>
    <!-- Scriptjs com as animações -->
    <script src="js/script.js"></script>
</body>

</html>